
// ScfPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScfPlayer.h"
#include "ScfPlayerDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CScfPlayerDlg dialog

CScfPlayerDlg::CScfPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CScfPlayerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pViewManager = NULL;
}

void CScfPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	
}

BEGIN_MESSAGE_MAP(CScfPlayerDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// CTESTSCFMULTIFILEPLAYERVS2010ACTIVEXDlg message handlers

BOOL CScfPlayerDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_ShowInfoDlg.Create( IDD_SHOWINFODLG );	

	m_ShowInfoDlg.ShowWindow( SW_HIDE );

	CString strTitle = "Yuan's  Scf File Player Demo Software ";	

	m_ShowInfoDlg.SetWindowText( strTitle );

	m_ShowInfoDlg.ShowWindow( SW_SHOW );

	UINT i = 0;

	m_pViewManager = new MyViewManager;	

	// CREATE CHANNEL WINDOW
	// 
	CString strWinName;

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		strWinName.Format( "MyChannelWindow%02d", i + 1 );

		m_oVideoWnd[ i ].m_nWndID = i;		

		m_oVideoWnd[ i ].Create( NULL, strWinName,  WS_CHILD | WS_VISIBLE | WS_BORDER, CRect(0, 0, 0, 0), this, i, NULL );				

		m_oVideoWnd[ i ].m_pParentDlg = this;

		m_oVideoWnd[ i ].ShowWindow( FALSE );
	}
	
	m_pViewManager->SetVideoWnds(LAYOUT01, m_oVideoWnd, 1);

	m_pViewManager->SetVideoWnds(LAYOUT04, m_oVideoWnd, 4);

	m_pViewManager->SetVideoWnds(LAYOUT09, m_oVideoWnd, 9);

	m_pViewManager->SetVideoWnds(LAYOUT16, m_oVideoWnd, 16);

	m_pViewManager->SetVideoWnds(LAYOUT36, m_oVideoWnd, 36);

	m_pViewManager->SetVideoWnds(LAYOUT64, m_oVideoWnd, 64);

	RECT rect;

	int nXResolution = 1800; //GetSystemMetrics( SM_CXSCREEN );

	int nYResolution = 960; // GetSystemMetrics( SM_CYSCREEN );

	rect.left = 0;  rect.top = 0;  rect.right = nXResolution;  rect.bottom = nYResolution;

	MoveWindow( 0, 0, nXResolution, nYResolution );

	m_pViewManager->SetLayoutRect(rect);

	//m_pViewManager->Activate( LAYOUT16, TRUE );

	m_pViewManager->Activate( LAYOUT09, TRUE );

	SetWindowText( "Yuan's Scf File Player Demo Software" );

	CenterWindow( GetDesktopWindow() );

	ShowWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CScfPlayerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CScfPlayerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CScfPlayerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	if (m_pViewManager) { delete m_pViewManager;  m_pViewManager = NULL; }
}

BOOL CScfPlayerDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class

	if(pMsg->message == WM_KEYDOWN)
	{		
		if (pMsg->wParam == VK_ESCAPE)
		{
			SendMessage( WM_CLOSE, 0, 0 );

			return FALSE;
		}
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

void CScfPlayerDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default		

	CDialogEx::OnClose();
}